Attribute VB_Name = "modSystem"
Option Explicit

Public CancelApp As Boolean
Public EndApp As Boolean

Public FragmentSize As Double
Public InputFile As String
Public OutputFolder As String

Private Buffer(0 To 524287) As Byte

Public Sub SplitFile()
On Error Resume Next
Dim i As Long
Dim j As Long

Dim FPath As String
Dim FName As String
Dim FExt As String
Dim FNameNoExt As String

' Variables used to hold values returned by the ReadFile and WriteFile API functions
Dim bRead As Long
Dim bWrote As Long

' File handles used to read and write to files
Dim fIn As Long     ' input file handle
Dim fOut As Long    ' output file handle

' Temporary variables
Dim TempCurr As Currency
Dim TempDbl As Double
Dim TempLng As Long

' Other variables
Dim SourceBytes As Double  ' file size of first file
Dim DestinationFile As String
Dim FragmentNumber As Integer

Dim dFileNoMask As String
Dim extMask As String

Dim RemainingBytes As Double
Dim BytesDone As Double

Dim Progress As Double
Dim Speed As Double
Dim OldTime As Double
Dim NewTime As Double
Dim OldBytes As Double
Dim NewBytes As Double

Dim Count As Long

'Ensure that the Fragment size is valid
If FragmentSize = 0 Then
   MsgBox "The part size is invalid.", vbOKOnly Or vbCritical, "Error"
   ResetInterface
   Exit Sub
End If

' Make sure the file exists
If InputFile = "" Then ' no file specified
   MsgBox "The file name is invalid.", vbOKOnly Or vbCritical, "Error"
   ResetInterface
   Exit Sub
End If

' Try to open the input file for reading
fIn = CreateFile(InputFile, GENERIC_READ, FILE_SHARE_READ Or FILE_SHARE_WRITE, 0&, OPEN_EXISTING, 0, 0)
If fIn = INVALID_HANDLE_VALUE Then  ' couldn't open the input file
   MsgBox "The input file can not be opened.", vbOKOnly Or vbCritical, "Error"
   ResetInterface
   Exit Sub
End If
' Split the complete file name into path, name and extension
SplitFullPath InputFile, FPath, FNameNoExt, FExt
' Combine name and extension to determine filename.ext
FName = FNameNoExt & "." & FExt

' Get file size of input file, using directly the file handle already opened when
'checking for file existance

GetFileSizeEx fIn, TempCurr
SourceBytes = TempCurr * 10000
If SourceBytes = 0 Then
 MsgBox "Empty files can not be splitted.", vbOKOnly Or vbCritical, "Error"
 ResetInterface
 Exit Sub
End If

' Determine the number of characters the output extension will have, depends on the
'number of parts that will be generated
    
TempDbl = Fix(SourceBytes / FragmentSize)
If TempDbl < SourceBytes / FragmentSize Then TempDbl = TempDbl + 1
' The extension mask
extMask = String$(Len(Str$(TempDbl)) - 1, vbKey0)

'File name for deleting fragment files
dFileNoMask = OutputFolder & FName

BytesDone = 0
OldTime = GetTickCount()
OldBytes = 0

Do
 
 'Increase the number of Fragments counter by 1
 FragmentNumber = FragmentNumber + 1
        
 'Compose the file name of the new file to be created (file Fragment)
 DestinationFile = OutputFolder & FName & "." & CStr(Format(FragmentNumber, extMask))
                    
 'Create the new file fragment and open it in write mode
 ' But first, close any output file that may still be open
 If fOut <> INVALID_HANDLE_VALUE Then CloseHandle fOut
 fOut = CreateFile(DestinationFile, GENERIC_WRITE, FILE_SHARE_READ Or FILE_SHARE_WRITE, 0&, CREATE_ALWAYS, 0, 0)
 If fOut = INVALID_HANDLE_VALUE Then ' couldn't open the output file
  MsgBox "Error opening " & DestinationFile & " in write mode. Process aborted.", vbOKOnly Or vbCritical, "Error"
  CloseHandle fIn
  DeleteFragmentFiles extMask, dFileNoMask
  ResetInterface
  Exit Sub
 End If
 
 If SourceBytes - BytesDone < FragmentSize Then
    RemainingBytes = SourceBytes - BytesDone
 Else
    RemainingBytes = FragmentSize
 End If
       
 Do
 
  'Clean up everything if canceled
 If CancelApp Or EndApp Then
   CloseHandle fIn
   CloseHandle fOut
   DeleteFragmentFiles extMask, dFileNoMask
   PBarSetPos 1, 0
   If EndApp Then
    PBarUnload 1
    End
   Else
    MsgBox "Cancelled", vbOKOnly Or vbInformation, "File Splitter"
   End If
   ResetInterface
   Exit Sub
 End If


 Select Case RemainingBytes
  Case Is > 524288
                    ReadFile fIn, Buffer(0), 524288, bRead, ByVal 0&
                    WriteFile fOut, Buffer(0), 524288, bWrote, ByVal 0&
                    RemainingBytes = RemainingBytes - 524288
                    BytesDone = BytesDone + 524288
                    'NewDoEvents
 Case 32769 To 524288
                    TempLng = (RemainingBytes \ 4096) * 4096
                    ReadFile fIn, Buffer(0), TempLng, bRead, ByVal 0&
                    WriteFile fOut, Buffer(0), TempLng, bWrote, ByVal 0&
                    RemainingBytes = RemainingBytes - TempLng
                    BytesDone = BytesDone + TempLng
                    'NewDoEvents
 Case 1 To 32768
                    ReadFile fIn, Buffer(0), RemainingBytes, bRead, ByVal 0&
                    WriteFile fOut, Buffer(0), RemainingBytes, bWrote, ByVal 0&
                    BytesDone = BytesDone + RemainingBytes
                    RemainingBytes = 0
                    'NewDoEvents
 Case Is = 0
                    'When the loop enters here, the Fragment bytes are completed.
                    'Close the Fragment file and exit the loop
                    CloseHandle fOut
                    'NewDoEvents
                    Exit Do
 End Select

 NewTime = GetTickCount()
 If NewTime = OldTime Then NewTime = OldTime + 1 ' prevent division by 0 if speed is too fast
 NewBytes = BytesDone
 Progress = (BytesDone / SourceBytes) * 100
 If Progress > 100 Then Progress = 100
 Count = Count + 1
 If Count > 5 Then
  Speed = (NewBytes - OldBytes) / (NewTime - OldTime)
  Speed = Speed * 0.9765
  OldBytes = NewBytes
  OldTime = NewTime
  Count = 0
 End If
 frmMain.lblProgressText.Caption = "Working: " & CStr(Round(BytesDone / 1024, 0)) & "KB read so far at " & CStr(Round(Speed, 2)) & "KB/s (" & CStr(Round(Progress, 2)) & "%)"
 PBarSetPos 1, Int(Progress)
 NewDoEvents
 Loop
    
Loop Until BytesDone = SourceBytes
'Close the source file
CloseHandle fIn
'Close destination file, if any remained open
CloseHandle fOut
ResetInterface
MsgBox "Done.", vbInformation Or vbOKOnly, "File Splitter"
End Sub

Public Sub SplitFullPath(ByVal CompletePath As String, ByRef FilePath As String, ByRef FileName As String, ByRef FileExt As String)
On Error Resume Next
Dim pos As Long
Dim pos2 As Long
Dim s As String
s = CompletePath
pos = 0
pos2 = InStr(1, s, "\")
While pos2 > 0
 pos = pos2: pos2 = InStr(pos2 + 1, s, "\")
Wend
If pos = 0 Then
  FilePath = ""
Else
  FilePath = Left(s, pos)
  s = Mid(s, pos + 1)
End If

pos = 0
pos2 = InStr(1, s, ".")
While pos2 > 0
 pos = pos2: pos2 = InStr(pos2 + 1, s, ".")
Wend

If pos = 0 Then
  FileName = s
  FileExt = ""
Else
  FileName = Left(s, pos - 1)
  FileExt = Mid(s, pos + 1)
End If
  

End Sub

Private Sub DeleteFragmentFiles(eMask As String, sFileName As String)

Dim fFile As String
Dim fNum As Integer
Do
    fNum = fNum + 1
    fFile = sFileName & "." & CStr(Format(fNum, eMask))
    If Dir(fFile) = "" Then Exit Do
    Kill fFile
Loop

End Sub

Private Sub ResetInterface()
frmMain.cmdStart.Caption = "Start"
frmMain.lblProgressText.Caption = "Ready."
CancelApp = False
EndApp = False
PBarSetPos 1, 0
End Sub
